<?php $__env->startSection('title', 'Product Information'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Product Information</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Show Product</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <!-- Default box -->
    <div class="card card-solid">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">
                        Product Details
                    </h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('product/'.$product->id.'/edit')); ?>" class="btn btn-info">
                        <i class="fas fa-edit"></i>
                        Edit
                    </a>
                    <a href="<?php echo e(routeHelper('product')); ?>" class="btn btn-danger">
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-12 col-sm-6">
                    <h3 class="d-inline-block d-sm-none">LOWA Men’s Renegade GTX Mid Hiking Boots Review</h3>
                    <div class="col-12">
                        <img src="<?php echo e(asset('uploads/product/'.$product->image)); ?>" class="product-image" alt="Product Image">
                    </div>
                    <div class="col-12 product-image-thumbs">
                        <div class="product-image-thumb active">
                            <img src="<?php echo e(asset('uploads/product/'.$product->image)); ?>" alt="Product Image">
                        </div>
                        <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="product-image-thumb active">
                                <img src="<?php echo e(asset('uploads/product/'.$image->name)); ?>" alt="Product Image">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </div>
                </div>
                <div class="col-12 col-sm-6">
                    <h3 class="my-3"><?php echo e($product->title); ?></h3>
                    <p><?php echo e($product->short_description); ?></p>

                    <hr>
                     <h4>Available Colors</h4>
                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                        <?php $__currentLoopData = $colors_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="btn btn-default text-center active">
                                <?php echo e($color->name); ?>

                                <br>
                                <i class="fas fa-circle fa-2x" style="color: <?php echo e($color->code); ?>"></i>
                                <br>
                                 Price:<?php echo e($color->price); ?>---Qnty:<?php echo e($color->qnty); ?>

                            </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        
                    </div>
                     <?php $__currentLoopData = $attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <h4 class="mt-3">Available <?php echo e($attribute->name); ?></h4>
                    <div class="btn-group btn-group-toggle" data-toggle="buttons">
                         <?php 
                            $attribute_prouct = DB::table('attribute_product')
                              ->select('*')
                              ->join('attribute_values', 'attribute_values.id', '=', 'attribute_product.attribute_value_id')
                              ->addselect('attribute_values.name as vName' )
                              ->addselect('attribute_product.id as vid' )
                              ->join('attributes', 'attributes.id', '=', 'attribute_values.attributes_id')
                              ->where('attribute_product.product_id', $product->id)
                                ->where('attributes.id', $attribute->id)
                              ->get();
                        ?>
                        <?php $__currentLoopData = $attribute_prouct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro_color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <label class="btn btn-default text-center active">
                            <?php echo e($pro_color->vName); ?>

                            <br>
                             Price:<?php echo e($pro_color->price); ?>---Qnty:<?php echo e($pro_color->qnty); ?>

                        </label>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <div class="bg-gray py-2 px-3 mt-4">
                        <h4 class="mb-0">
                          Regular Price: <?php echo e($product->regular_price); ?>

                        </h4>
                        <h4 class="mt-0">
                          <small>Discount Price: <?php echo e($product->discount_price); ?> </small>
                        </h4>
                        <h4 class="mt-0">
                            <small>
                                Shipping Charge:
                                <?php if($product->shipping_charge): ?>
                                    Dummy
                                <?php else: ?>
                                    Free
                                <?php endif; ?>
                            </small>
                        </h4>
                        <h4 class="mt-0"><small>Quantity: <?php echo e($product->quantity); ?></small> </h4>
                        <h4 class="mt-0">
                            <small>Stock: 
                                <?php if($product->quantity > 0): ?>
                                    Available
                                <?php else: ?>
                                    Unavailable
                                <?php endif; ?> 
                            </small>
                        </h4>
                        <?php if(isset($product->brand->name)): ?>
                        <h4 class="mt-0"><small>Brand: <?php echo e($product->brand->name); ?></small> </h4>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row mt-4">
                <nav class="w-100">
                    <div class="nav nav-tabs" id="product-tab" role="tablist">
                        <a class="nav-item nav-link active" id="product-desc-tab" data-toggle="tab" href="#product-desc" role="tab" aria-controls="product-desc" aria-selected="true">Description</a>
                        <a class="nav-item nav-link" id="product-comments-tab" data-toggle="tab" href="#product-comments" role="tab" aria-controls="product-comments" aria-selected="false">Comments</a>
                        <a class="nav-item nav-link" id="product-rating-tab" data-toggle="tab" href="#product-rating" role="tab" aria-controls="product-rating" aria-selected="false">Rating</a>
                        <a class="nav-item nav-link" id="product-categories-tab" data-toggle="tab" href="#product-categories" role="tab" aria-controls="product-categories" aria-selected="false">Categories</a>
                        <a class="nav-item nav-link" id="product-sub-categories-tab" data-toggle="tab" href="#product-sub-categories" role="tab" aria-controls="product-sub-categories" aria-selected="false">Sub Categories</a>
                        <a class="nav-item nav-link" id="product-tags-tab" data-toggle="tab" href="#product-tags" role="tab" aria-controls="product-tags" aria-selected="false">Tags</a>
                        <?php if($product->downloads->count() > 0): ?>
                        <a class="nav-item nav-link" id="product-downloads-tab" data-toggle="tab" href="#product-downloads" role="tab" aria-controls="product-downloads" aria-selected="false">Downloadable Files</a>
                        <?php endif; ?>
                    </div>
                </nav>
                <div class="tab-content p-3" id="nav-tabContent">
                    <div class="tab-pane fade show active" id="product-desc" role="tabpanel" aria-labelledby="product-desc-tab">
                        <?php echo $product->full_description; ?>

                    </div>
                    <div class="tab-pane fade" id="product-comments" role="tabpanel" aria-labelledby="product-comments-tab"></div>
                    <div class="tab-pane fade" id="product-rating" role="tabpanel" aria-labelledby="product-rating-tab"></div>
                    <div class="tab-pane fade" id="product-categories" role="tabpanel" aria-labelledby="product-categories-tab">
                        <?php $__empty_1 = true; $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                            <?php if($product->categories->last()->id == $category->id): ?>
                                <strong><?php echo e($category->name); ?></strong>
                            <?php else: ?>
                                <strong><?php echo e($category->name); ?>,</strong>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <strong>Not Available</strong>
                        <?php endif; ?>
                    </div>
                    <div class="tab-pane fade" id="product-sub-categories" role="tabpanel" aria-labelledby="product-sub-categories-tab">
                        <?php $__empty_1 = true; $__currentLoopData = $product->sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                            <?php if($product->sub_categories->last()->id == $sub_category->id): ?>
                                <strong><?php echo e($sub_category->name); ?></strong>
                            <?php else: ?>
                                <strong><?php echo e($sub_category->name); ?>,</strong>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <strong>Not Available</strong>
                        <?php endif; ?>
                    </div>
                    <div class="tab-pane fade" id="product-tags" role="tabpanel" aria-labelledby="product-tags-tab">
                        <?php $__empty_1 = true; $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            
                            <?php if($product->tags->last()->id == $tag->id): ?>
                                <strong><?php echo e($tag->name); ?></strong>
                            <?php else: ?>
                                <strong><?php echo e($tag->name); ?>,</strong>
                            <?php endif; ?>
                            
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <strong>Not Available</strong>
                        <?php endif; ?>
                    </div>
                    <div class="tab-pane fade" id="product-downloads" role="tabpanel" aria-labelledby="product-downloads-tab">
                        <?php $__currentLoopData = $product->downloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $download): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="mb-3">
                                <p><strong>File Name: </strong><a href=""><?php echo e($download->name); ?></a></p>
                                <?php if($download->url != NULL): ?>
                                    <p><strong>File URL: </strong><a href=""><?php echo e($download->url); ?></a></p>
                                <?php else: ?>
                                    <p><strong>File URL: </strong><a href=""><?php echo e(asset('uploads/product/download/'.$download->url)); ?></a></p>
                                <?php endif; ?>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.card-body -->
      </div>
      <!-- /.card -->

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.vendor.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\resources\views/vendor/product/show.blade.php ENDPATH**/ ?>