<?php $__env->startSection('title', 'Order List'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Order List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Order List</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Order List</h3>
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Invoice</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Payment</th>
                        <th>Subtotal</th>
                        <th>Discount</th>
                        <th>Total</th>
                        <th>Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e($data->invoice); ?></td>
                            <td><?php echo e($data->first_name); ?></td>
                            <td><?php echo e($data->phone); ?></td>
                            <td><?php echo e($data->payment_method); ?></td>
                            <td><?php echo e($data->subtotal); ?></td>
                            <td><?php echo e($data->discount); ?></td>
                            <td><?php echo e($data->total); ?></td>
                            <td><?php echo e(date('d M Y', strtotime($data->created_at))); ?></td>
                            <td>
                                <?php if($data->status == 0): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif($data->status == 1): ?>
                                    <span class="badge badge-primary">order confirm</span>
                                <?php elseif($data->status == 2): ?>
                                    <span class="badge badge-danger">Canceled</span>
                                <?php elseif($data->status == 5): ?>
                                    <span class="badge badge-danger">refund</span>
                                <?php elseif($data->status == 4): ?>
                                    <span class="badge" style="background: #7db1b1;">Shipping</span>
                                <?php elseif($data->status == 6): ?>
                                    <span class="badge badge-warning"><small>Return<br>Requested</small></span>
                                <?php elseif($data->status == 7): ?>
                                    <span class="badge badge-warning"><small>Returning by Customer</small></span>
                                <?php elseif($data->status == 8): ?>
                                    <span class="badge badge-danger">Returned</span>
                                <?php elseif($data->status == 9): ?>
                                    <span class="badge badge-danger"><small>Sended to Courier</small></span>
                                <?php elseif($data->status == 3): ?>
                                    <span class="badge badge-success">Delivered</span>
                                <?php endif; ?>  
                            </td>
                            <td>
                                <div class="btn btn-group">
                                    <a title="Invoice" href="<?php echo e(route('admin.order.invoice', $data->id)); ?>" class="btn btn-warning btn-sm" target="_blank">
                                        <i class="fas fa-print"></i>
                                    </a>
                                    <a title="Show Information" href="<?php echo e(routeHelper('order/'. $data->id)); ?>" class="btn btn-info btn-sm">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <!-- <?php if($data->status == 0): ?>
                                    <a title="Done" href="<?php echo e(routeHelper('order/status/processing/'. $data->id)); ?>" id="btnStatus" onclick="return confirm('Are you sure change this order status?')" class="btn btn-primary btn-sm">
                                        <i class="fas fa-check"></i>
                                    </a>
                                   
                                    <a title="Shipping" href="<?php echo e(routeHelper('order/status/shipping/'. $data->id)); ?>" id="btnShipping" onclick="return confirm('Are you sure Shipping this order?')" class="btn btn-success btn-sm">
                                        <i class="fas fa-plane"></i>
                                    </a>
                                    <a title="Delivered" href="<?php echo e(routeHelper('order/status/delivered/'. $data->id)); ?>" id="btnDelivered" onclick="return confirm('Are you sure delivered this order?')" class="btn btn-success btn-sm">
                                        <i class="fas fa-thumbs-up"></i>
                                    </a>
                                    <?php elseif($data->status == 1): ?>
                                        
                                        <a title="Shipping" href="<?php echo e(routeHelper('order/status/shipping/'. $data->id)); ?>" id="btnShipping" onclick="return confirm('Are you sure Shipping this order?')" class="btn btn-success btn-sm">
                                        <i class="fas fa-plane"></i>
                                        </a>
                                        <a title="Delivered" href="<?php echo e(routeHelper('order/status/delivered/'. $data->id)); ?>" id="btnDelivered" onclick="return confirm('Are you sure delivered this order?')" class="btn btn-success btn-sm">
                                            <i class="fas fa-thumbs-up"></i>
                                        </a>
                                    <?php elseif($data->status == 4): ?>
                                       
                                        <a title="Delivered" href="<?php echo e(routeHelper('order/status/delivered/'. $data->id)); ?>" id="btnDelivered" onclick="return confirm('Are you sure delivered this order?')" class="btn btn-success btn-sm">
                                            <i class="fas fa-thumbs-up"></i>
                                        </a>
                                    
                                    <?php endif; ?>
                                    <?php if($data->status != 2 && $data->status != 3): ?>
                                     <a title="Cancel" href="<?php echo e(routeHelper('order/status/cancel/'. $data->id)); ?>" id="btnCancel" onclick="return confirm('Are you sure cancel this order?')" class="btn btn-danger btn-sm">
                                            <i class="fas fa-window-close"></i>
                                        </a>
                                        <?php endif; ?> -->
                                </div>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
      <!-- /.card -->    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <!-- DataTables  & Plugins -->
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="/assets/plugins/jszip/jszip.min.js"></script>
    <script src="/assets/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="/assets/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script>
        $(function () { 
            $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
            

        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ofsbazar/public_html/resources/views/admin/e-commerce/order/index.blade.php ENDPATH**/ ?>