 
<?php $__env->startPush('meta'); ?>
<meta name='description' content="Order List"/>
<meta name='keywords' content="E-commerce, Best e-commerce website" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Order List'); ?>
<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
  <style>
     #example1_wrapper {
        background: white;
padding: 10px;
border-radius: 5px;
      }
      td{
        border-bottom: 1px solid gainsboro;
        padding: 5px 0px;
      }
  </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>

<div class="customar-dashboard">
    <div class="container">
        <div class="customar-access row">
            <div class="customar-menu col-md-3">
                <?php echo $__env->make('layouts.frontend.partials.userside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-9" style="margin-top:20px">
                <table style="margin-top: 20px;background: white;" class="timetable_sub" id="example1">
                    <thead>
                        <tr>
                            <th>Order NO.</th>
                            <th>Price</th>
                            <th>Qty</th>
                            <th>Total</th>
                            <th>Status</th>
                            <th>Date</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td><?php echo e(number_format($order->orderDetails->sum('price'), 2, '.', ',')); ?></td>
                            <td><?php echo e($order->orderDetails->sum('qty')); ?></td>
                            <td><?php echo e(number_format($order->total, 2, '.', ',')); ?></td>
                            <td>
                                <?php if($order->status == 0): ?>
                                    <span class="badge badge-warning">Pending</span>
                                <?php elseif($order->status == 1): ?>
                                    <span class="badge badge-primary">Processing</span>
                                <?php elseif($order->status == 2): ?>
                                    <span class="badge badge-danger">Canceled</span>
                                <?php elseif($order->status == 4): ?>
                                    <span class="badge" style="background: #7db1b1;">Shipping</span>
                                <?php elseif($order->status == 5): ?>
                                    <span class="badge  badge-danger">Refund</span>
                                <?php elseif($order->status == 6): ?>
                                    <span class="badge badge-warning">Return Requested</span>
                                <?php elseif($order->status == 7): ?>
                                    <span class="badge" style="background: #7db1b1;"><small>Return Accepted<br>you can now return this product</small></span>
                                <?php elseif($order->status == 8): ?>
                                    <span class="badge" style="background: #7db1b1;">Returned</span>
                                <?php else: ?> 
                                    <span class="badge badge-success">Delivered</span>
                                <?php endif; ?>  
                            </td>
                            <td><?php echo e(date('d M Y', strtotime($order->created_at))); ?></td>
                            <td>
                                
                                <?php if($order->pay_staus!=1 && $order->status != 3  && $order->status != 2): ?>
                                <a class="btn btn-info"  href="<?php echo e(route('order.pay.form', $order->order_id)); ?>">Pay</a>
                                 <?php endif; ?>
                                <a class="btn badge-primary" href="<?php echo e(route('order.invoice', $order->id)); ?>">View</a>
                                   <!--<form style="display: inline;width: initial !important;"  action="<?php echo e(route('tracking')); ?>" method="post">-->
                                   <!--     <?php echo csrf_field(); ?>-->
                                   <!--     <input type="hidden" value="1" name="pt" />-->
                                   <!--    <input type="hidden" value="<?php echo e($order->invoice); ?>" name="invoice" id="invoice" class="form-control" required />-->
                                          
                                   <!--         <input style="display: inline;width: initial !important;"  class="form-control" type="submit" value="View">-->
                                       
                                   <!-- </form>-->
        

                                <?php if($order->status == 0): ?>
                                    <a class="btn btn-warning"  href="<?php echo e(route('order.cacnel', $order->id)); ?>">Cancel</a>
                                <?php endif; ?>
                                <?php if($order->status == 3): ?>
                                    <a class="btn btn-success" href="<?php echo e(route('review', $order->order_id)); ?>">Review</a>
                                    <a class="btn btn-danger" href="<?php echo e(route('order.return_req', $order->id)); ?>">Return</a>
                                <?php endif; ?>
                                
                            </td>
                        </tr>  
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
     <script>
        $(function () { 
            $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ofsbazar/public_html/resources/views/frontend/returns_order.blade.php ENDPATH**/ ?>