<?php $__env->startPush('meta'); ?>
<meta name='description' content="Download Product File"/>
<meta name='keywords' content="E-commerce, Best e-commerce website" />
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Order List'); ?>

<?php $__env->startSection('content'); ?>

<div class="customar-dashboard">
    <div class="container">
        <div class="customar-access row">
            <div class="customar-menu col-md-3">
                <?php echo $__env->make('layouts.frontend.partials.userside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-md-9">
                <table style="margin-top: 20px;background: white;" class="timetable_sub">
                    <thead>
                        <tr>
                            <th>Order NO.</th>
                            <th>Product</th>
                            <th>Download Remaining</th>
                            <th>Expires</th>
                            <th>Download</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($item->product->download_able): ?>
                                <tr>
                                    <td><?php echo e($key + 1); ?></td>
                                    <td>
                                        <img src="<?php echo e(asset('uploads/product/'.$item->product->image)); ?>" alt="Product Image" width="70px">    
                                    </td>
                                    <?php
                                        $total_download = DB::table('download_user_products')
                                                        ->where('user_id', auth()->id())
                                                        ->where('product_id', $item->product->id)
                                                        ->count();
                                        $download_remaining = ($item->product->downloads->count() * $item->product->download_limit) - $total_download;
                                    ?>
                                    <td><?php echo e($item->product->downloads->count() > 0 ? $download_remaining:0); ?></td>
                                    <td><?php echo e(date('d/m/Y', strtotime($item->product->download_expire))); ?></td>
                                    <td>
                                        <?php $__currentLoopData = $item->product->downloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $download): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <a href="<?php echo e(route('download.product', ['pro_id' =>$item->product->id, 'id' => $download->id])); ?>">Link <?php echo e($key+1); ?></a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </td>
                                </tr>  
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                         
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>

<script>
    $(document).ready(function () {
        $(document).on('click', '#download', function(e) {
            e.preventDefault();
            
            let url = $(this).attr('href');
            $.ajax({
                type: 'GET',
                url: url,
                dataType: "JSON",
                success: function (response) {
                    console.log(response);
                }
            });
        });
    });
</script>
    
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce2.elitedesign.com.bd/resources/views/frontend/download.blade.php ENDPATH**/ ?>