<?php $__env->startSection('title', 'Unaproved Product List'); ?>

<?php $__env->startPush('css'); ?>
    <!-- DataTables -->
  <link rel="stylesheet" href="/assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="/assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Unaproved Product List</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">Unaproved Product List</li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">

    <div class="card">
        <div class="card-header">
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">Disable Product List</h3>
                </div>
                <div class="col-sm-6 text-right">
                    <a href="<?php echo e(routeHelper('product/create')); ?>" class="btn btn-success">
                        <i class="fas fa-plus-circle"></i>
                        Add Product
                    </a>
                </div>
            </div>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>SL</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>RP</th>
                        <th>DP</th>
                        <th>Stock</th>
                        <th>Brand</th>
                        <th>is_aproved</th>
                        <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td><?php echo e($key + 1); ?></td>
                            <td>
                                <img src="<?php echo e(asset('uploads/product/'.$data->image)); ?>" alt="Product Image" width="60px">    
                            </td>
                            <td><?php echo e($data->title); ?></td>
                            <td><?php echo e($data->regular_price); ?></td>
                            <td><?php echo e($data->discount_price); ?></td>
                            <td>
                                <?php if($data->quantity > 0): ?>
                                <span class="badge badge-success">Available</span>
                                <?php else: ?>
                                <span class="badge badge-danger">Unavailable</span>
                                <?php endif; ?>    
                            </td>
                            <td><?php echo e($data->brand->name ?? ''); ?></td>
                            <td>
                                <span class="badge badge-danger">Unapproved</span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?php echo e(route('admin.product.order', $data->id)); ?>" title="Order Product" class="btn btn-primary btn-sm">
                                        <i class="fab fa-jedi-order"></i>
                                    </a>
                                    <a title="Disable" href="<?php echo e(routeHelper('product/status/'.$data->id)); ?>" class="btn btn-danger btn-sm">
                                        <i class="fas fa-thumbs-down"></i>
                                    </a> 
                                  
                                    <a href="<?php echo e(routeHelper('product/'. $data->id)); ?>" class="btn btn-primary btn-sm">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?php echo e(routeHelper('product/'.$data->id.'/edit')); ?>" class="btn btn-info btn-sm">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                       <?php if(auth()->user()->desig !=3): ?>
                                   <a href="javascript:void(0)" data-id="<?php echo e($data->id); ?>" id="deleteData" class="btn btn-danger btn-sm">
                                        <i class="nav-icon fas fa-trash-alt"></i>
                                    </a>
                                    <?php endif; ?>
                                    <form id="delete-data-form-<?php echo e($data->id); ?>" action="<?php echo e(routeHelper('product/'. $data->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                    </form>
                                </div>
                                
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
                <tfoot>
                    <tr>
                        <th>SL</th>
                        <th>Image</th>
                        <th>Title</th>
                        <th>RP</th>
                        <th>DP</th>
                        <th>Stock</th>
                        <th>Brand</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </tfoot>
            </table>
        </div>
        <!-- /.card-body -->
    </div>
      <!-- /.card -->    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <!-- DataTables  & Plugins -->
    <script src="/assets/plugins/datatables/jquery.dataTables.min.js"></script>
    <script src="/assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
    <script src="/assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/dataTables.buttons.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js"></script>
    <script src="/assets/plugins/jszip/jszip.min.js"></script>
    <script src="/assets/plugins/pdfmake/pdfmake.min.js"></script>
    <script src="/assets/plugins/pdfmake/vfs_fonts.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.html5.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.print.min.js"></script>
    <script src="/assets/plugins/datatables-buttons/js/buttons.colVis.min.js"></script>
    <script>
        $(function () { 
            $("#example1").DataTable({
            "responsive": true, "lengthChange": false, "autoWidth": false,
            "buttons": ["copy", "csv", "excel", "pdf", "print", "colvis"]
            }).buttons().container().appendTo('#example1_wrapper .col-md-6:eq(0)');
        })
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitedesign/ecommerce2.elitedesign.com.bd/resources/views/admin/e-commerce/product/unapprove.blade.php ENDPATH**/ ?>