<?php $__env->startSection('title'); ?>
    <?php if(isset($product)): ?>
        Edit Product 
    <?php else: ?> 
        Add Product
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
    <!-- Select2 -->
    <link rel="stylesheet" href="/assets/plugins/select2/css/select2.min.css">
    <link rel="stylesheet" href="/assets/plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Dropify/0.2.2/css/dropify.min.css" integrity="sha512-EZSUkJWTjzDlspOoPSpUFR0o0Xy7jdzW//6qhUkoZ9c4StFkVsp9fbbd0O06p9ELS3H486m4wmrCELjza4JEog==" crossorigin="anonymous" />
    <link rel="stylesheet" href="/assets/plugins/summernote/summernote-bs4.min.css">
    <link rel="stylesheet" href="/assets/plugins/dropzone/min/dropzone.min.css">
    <link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link type="text/css" rel="stylesheet" href="/assets/plugins/file-uploader/image-uploader.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.5.3/css/bootstrap-colorpicker.min.css" rel="stylesheet">
    <style>
        .spec{
            background: gainsboro;
        }
        .dropify-wrapper .dropify-message p {
            font-size: initial;
        }
        .custom-file::-webkit-file-upload-button {
            visibility: hidden;
        }
        .custom-file::before {
            content: 'Choose File';
            display: inline-block;
            background: linear-gradient(top, #f9f9f9, #e3e3e3);
            border: 1px solid #ced4da;
            border-radius: 3px;
            padding: 8px 8px;
            outline: none;
            white-space: nowrap;
            -webkit-user-select: none;
            cursor: pointer;
            text-shadow: 1px 1px #fff;
            font-weight: 700;
            font-size: 10pt;
            width: 100%;
            text-align: center;
        }
        .note-editor{
            box-shadow: none !important;
        }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>
                    <?php if(isset($product)): ?>
                        Edit Product 
                    <?php else: ?> 
                        Add Product
                    <?php endif; ?>
                </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(routeHelper('dashboard')); ?>">Home</a></li>
                    <li class="breadcrumb-item active">
                        <?php if(isset($product)): ?>
                            Edit Product 
                        <?php else: ?> 
                            Add Product
                        <?php endif; ?>
                    </li>
                </ol>
            </div>
        </div>
    </div><!-- /.container-fluid -->
</section>

<!-- Main content -->
<section class="content">
    <!-- Default box -->
    <?php if($errors->any()): ?>
    <?php echo implode('', $errors->all('<div class="alert alert-danger">:message</div>')); ?>

    <?php endif; ?>
    <div class="card">
        <div class="card-header">
            
            <div class="row">
                <div class="col-sm-6">
                    <h3 class="card-title">
                        <?php if(isset($product)): ?>
                            Edit Product
                        <?php else: ?> 
                            Add New Product
                        <?php endif; ?>
                    </h3>
                </div>
                <div class="col-sm-6 text-right">
                    <?php if(isset($product)): ?>
                    <a href="<?php echo e(routeHelper('product/'. $product->id)); ?>" class="btn btn-info">
                        <i class="fas fa-eye"></i>
                        Show
                    </a>
                    <?php endif; ?>
                    <a href="<?php echo e(routeHelper('product')); ?>" class="btn btn-danger">
                        <i class="fas fa-long-arrow-alt-left"></i>
                        Back to List
                    </a>
                </div>
            </div>
        </div>
        <style>
            .nc{
                border: 1px solid gainsboro;margin-top: 10px;
            }
        </style>
        <div class="row">
            <form class="col-sm-8" action="<?php echo e(isset($product) ? routeHelper('product/'.$product->id) : routeHelper('product')); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php if(isset($product)): ?>
                    <input type="hidden" value="<?php echo e($product->id); ?>" id="id">
                    <?php echo method_field('PUT'); ?>
                <?php endif; ?>
                <input type="hidden" value="<?php echo e($type??''); ?>" name="ptypen">

                <div class="card-body">
                    <div class="form-group">
                        <label for="title">Product name <span class="text-danger">(*)</span>:</label>
                        <input type="text" name="title" id="title" placeholder="Write product title" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->title ?? old('title')); ?>" >
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="title">Product Code (SKU):</label>
                        <input type="text" name="sku" id="sku" placeholder="Product Code/SKU" class="form-control <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->sku ?? old('sku')); ?>" >
                        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group">
                        <label for="short_description">Short Description:</label>
                        <textarea name="short_description" id="short_description" rows="3" placeholder="Write product short description" class="form-control <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" ><?php echo e($product->short_description ?? old('short_description')); ?></textarea>
                        <?php $__errorArgs = ['short_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                        <label for="full_description">Select Vendor:</label>
                        <select class="form-control" name="vendor">
                            <option value="">Select Vendor Optional</option>
                            <?php $__currentLoopData = App\Models\ShopInfo::get(['name','user_id']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $vend): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option <?php if(isset($product->user_id)): ?><?php if($product->user_id==$vend->user_id): ?>selected <?php endif; ?>
                                <?php endif; ?> value="<?php echo e($vend->user_id); ?>"><?php echo e($vend->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="full_description">Full Description <span class="text-danger">(*)</span>:</label>
                        <textarea name="full_description" id="full_description" class="form-control"><?php echo e($product->full_description??old('full_description')); ?></textarea>
                        <?php $__errorArgs = ['full_description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-md-6">
                            <label for="buying_price">Buying Price:</label>
                            <input step="0.01" type="number" name="buying_price" id="buying_price" placeholder="Enter product buying price" class="form-control <?php $__errorArgs = ['buying_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->buying_price ?? old('buying_price')); ?>">
                            <?php $__errorArgs = ['buying_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="regular_price">Whole Sell Price:</label>
                            <input step="0.01" type="number" name="whole_price" id="whole_price" placeholder="Enter product whole sell price" class="form-control <?php $__errorArgs = ['whole_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->whole_price ?? old('whole_price')); ?>">
                            <?php $__errorArgs = ['whole_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="regular_price">Regular Price <span class="text-danger">(*)</span>:</label>
                            <input step="0.01" type="number" name="regular_price" id="regular_price" placeholder="Enter product regular price" class="form-control <?php $__errorArgs = ['regular_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->regular_price ?? old('regular_price')); ?>" required>
                            <?php $__errorArgs = ['regular_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="prdct_extra_msg">Product Extra Message:</label>
                            <input type="text" name="prdct_extra_msg" id="prdct_extra_msg" placeholder="Express Delivery in Dhaka" class="form-control <?php $__errorArgs = ['prdct_extra_msg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->prdct_extra_msg ?? ""); ?>">
                            <?php $__errorArgs = ['prdct_extra_msg'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="dis_type">Discount Type:</label>
                            <select name="dis_type" id="dis_type" class="form-control <?php $__errorArgs = ['dis_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="0" <?php if(isset($product)): ?> <?php echo e($product->dis_type == '0' ? 'selected':''); ?> <?php endif; ?>>None</option>
                                <option value="1" <?php if(isset($product)): ?> <?php echo e($product->dis_type == '1' ? 'selected':''); ?> <?php endif; ?>>Flat</option>
                                <option value="2" <?php if(isset($product)): ?> <?php echo e($product->dis_type == '2' ? 'selected':''); ?> <?php endif; ?>>Parcent %</option>
                            </select>
                            <?php $__errorArgs = ['dis_type'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <?php if(isset($product)): ?> 
                            <?php if($product->dis_type == '2'): ?>
                                <?php ($discount_price=(($product->regular_price - $product->discount_price) / ($product->regular_price ))*100); ?>
                            <?php else: ?>
                            <?php if($product->discount_price<1): ?>
                            <?php ($discount_price=''); ?>
                            <?php else: ?>
                                <?php ($discount_price=$product->regular_price-$product->discount_price); ?>
                                <?php endif; ?>
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="form-group col-md-6">
                            <label for="discount_price">Discount:</label>
                            <input step="0.01" type="number" name="discount_price" id="discount_price" placeholder="Enter product discount price" class="form-control <?php $__errorArgs = ['discount_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($discount_price ?? old('discount_price')); ?>" >
                            <?php $__errorArgs = ['discount_price'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="quantity">Point:</label>
                            <input type="number" name="point" id="point" placeholder="Enter product point" class="form-control <?php $__errorArgs = ['point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->point ?? old('point')); ?>" >
                            <?php $__errorArgs = ['point'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                    

                        <div class="form-group col-md-6">
                            <label for="quantity">Quantity <span class="text-danger">(*)</span>:</label>
                            <input type="number" name="quantity" id="quantity" placeholder="Enter product quantity" class="form-control <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->quantity ?? old('quantity')); ?>" required>
                            <?php $__errorArgs = ['quantity'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="brand">Select Brand <span class="text-danger">(*)</span>:</label>
                            <select name="brand" id="brand" data-placeholder="Select Brand" class="form-control select2 <?php $__errorArgs = ['brand'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                                <option value="">Select Brand</option>
                                <?php $__currentLoopData = $brands; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $brand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($brand->id); ?>" <?php if(isset($product)): ?> <?php echo e($brand->id == $product->brand_id ? 'selected':''); ?> <?php endif; ?>><?php echo e($brand->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['brand'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="category">Select Campaing:</label>
                            <select name="campaigns[]" id="campaign" multiple data-placeholder="Select Campaing" class="category form-control select2 <?php $__errorArgs = ['campaigns'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                                <option value="">Select Campaing</option>
                                <?php $__currentLoopData = $campaigns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $campaign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($campaign->id); ?>" <?php if(isset($product)): ?> <?php echo e($campaign->id == $product->brand_id ? 'selected':''); ?> <?php endif; ?>><?php echo e($campaign->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['campaigns'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="category">Select Category <span class="text-danger">(*)</span>:</label>
                            <select name="categories[]" id="category" multiple data-placeholder="Select Category" class="category form-control select2 <?php $__errorArgs = ['categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="">Select Category</option>
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($category->id); ?>" <?php if(isset($product)): ?> <?php $__currentLoopData = $product->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($category->id == $pro_category->id ? 'selected':''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>><?php echo e($category->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <div class="form-group col-md-6">
                            <label for="sub_category">Select Sub Category:</label>
                            <select name="sub_categories[]" id="sub_category" data-placeholder="Select Sub Category" class="sub_category form-control <?php echo e(isset($product) ? 'select2':''); ?> <?php $__errorArgs = ['sub_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  <?php echo e(isset($product) ? 'multiple':''); ?>>
                                <?php if(isset($product)): ?>
                                    <?php $__currentLoopData = $product->sub_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sub_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($sub_category->id); ?>" selected><?php echo e($sub_category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['sub_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="mini_category">Select Mini Category:</label>
                            <select name="mini_categories[]" id="mini_category" data-placeholder="Select Mini Category" class="mini_category form-control <?php echo e(isset($product) ? 'select2':''); ?> <?php $__errorArgs = ['mini_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  <?php echo e(isset($product) ? 'multiple':''); ?>>
                                <?php if(isset($product)): ?>
                                    <?php $__currentLoopData = $product->mini_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $mini_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($mini_category->id); ?>" selected><?php echo e($mini_category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['mini_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="extra_categories">Select Extra Category:</label>
                            <select name="extra_categories[]" id="extra_category" data-placeholder="Select Mini Category" class="extra_categories form-control <?php echo e(isset($product) ? 'select2':''); ?> <?php $__errorArgs = ['mini_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  <?php echo e(isset($product) ? 'multiple':''); ?>>
                                <?php if(isset($product)): ?>
                                    <?php $__currentLoopData = $product->extra_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $extra_category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($extra_category->id); ?>" selected><?php echo e($extra_category->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </select>
                            <?php $__errorArgs = ['extra_categories'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="tag">Select Tag:</label>
                            <select name="tags[]" id="tag" multiple data-placeholder="Select Tag" class="form-control select2 <?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                                <option value="">Select Tag</option>
                                <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($tag->id); ?>" <?php if(isset($product)): ?> <?php $__currentLoopData = $product->tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro_tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($tag->id == $pro_tag->id ? 'selected':''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>><?php echo e($tag->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>

                        <!-- <div class="form-group col-md-6">
                            <label for="size">Select Size:</label>
                            <select name="sizes[]" id="size" multiple data-placeholder="Select Size" class="form-control select2 <?php $__errorArgs = ['sizes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                                <option value="">Select Size</option>
                                <?php $__currentLoopData = $sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($size->id); ?>" <?php if(isset($product)): ?> <?php $__currentLoopData = $product->sizes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro_size): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($size->id == $pro_size->id ? 'selected':''); ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> <?php endif; ?>><?php echo e($size->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <?php $__errorArgs = ['sizes'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div> -->
                        <input type='hidden' name="shipping_charge" value="1">
                        <!-- <div class="form-group col-md-6">
                            <label for="tag">Shipping Charge:</label>
                            <select name="shipping_charge" id="shipping_charge" class="form-control <?php $__errorArgs = ['shipping_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" required>
                                <option value="1">Paid</option>
                                <option value="0">Free</option>
                            </select>
                            <?php $__errorArgs = ['shipping_charge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div> -->

                        <div class="form-group col-md-12">
                            <div style="background: #eeeeee;padding: 10px;border-radius: 5px;">
                                <div class="row">
                                    <div class="form-group col-md-12" style="margin-bottom: 5px;border:1px solid gainsboro;">
                                    <label style="display: block;" for="color"> <button style="width: 100%;text-align:left;" type="button" data-toggle="collapse" data-target="#collapseExampleColor" aria-expanded="false" aria-controls="collapseExampleColor">Select Color:<i style="float: right;top: 8px;position: relative;" class="fas fa-arrow-down"></i> </button></label>
                                    <div class="collapse" id="collapseExampleColor">
                                        <div style="display: flex;" class="input-group ">
                                                
                                                <select id="select_color"  data-placeholder="Select Color" class="form-control  <?php $__errorArgs = ['colors'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                                                    <option value="">Select Color</option>
                                                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option  style="color:white;background: <?php echo e($color->code); ?>" value="<?php echo e($color->slug.','.$color->id); ?>" ><?php echo e($color->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                                <?php $__errorArgs = ['colors'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                              
                                          </div>
                                          <div id="increment_color">
                                            <?php if(isset($product)): ?>
                                            <?php $__currentLoopData = $colors_product; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pro_color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="input-group mt-2"> 
                                                    <input class="form-control" type="hidden" readonly="" name="colors[]" value="<?php echo e($pro_color->id); ?>">
                                                     <input class="form-control" type="text"  readonly="" value="<?php echo e($pro_color->name); ?>"> 
                                                     <input class="form-control" type="number" placeholder="extra price" name="color_prices[]" value="<?php echo e($pro_color->price); ?>"> 
                                                     <input class="form-control" type="number" placeholder="extra quantity" name="color_quantits[]" value="<?php echo e($pro_color->qnty); ?>">
                                                      <div class="input-group-append" id="remove" style="cursor:context-menu">
                                                            <a href="<?php echo e(route('admin.color.delete.n2',['cc'=>$pro_color->id,'pp'=>$product->id])); ?>">
                                                                <span class="input-group-text">Remove</span>
                                                            </a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?> 
                                            <?php endif; ?>
                                              
                                          </div>
                                          </div>
                                    </div>
                                   

                                  
                                </div>
                                <div id="sho_attributes" class="row">
                                      
                                  </div>
                            </div>
                        </div>
  <h4 class="col-12"> <button style="width: 100%;text-align:left;" type="button" data-toggle="collapse" data-target="#BookOpen" aria-expanded="false" aria-controls="BookOpen">Specification for book:<i style="float: right;top: 8px;position: relative;" class="fas fa-arrow-down"></i> </button></h4>
                           
                        
                        <div class="form-row col-md-12 spec collapse" id="BookOpen">
                            
                           <div class="form-group col-md-6">
                                 <label for="full_description">Select Author:</label>
                                 <select class="form-control" name="author_id">
                                     <option value="">Select Vendor  </option>
                                     <?php $__currentLoopData = App\Models\Author::get(['name','id']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $author): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <option <?php if(isset($product->author_id)): ?><?php if($product->author_id==$author->id): ?>selected <?php endif; ?> <?php endif; ?> value="<?php echo e($author->id); ?>"><?php echo e($author->name); ?></option>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                 </select>
                            </div>
                             <div class="form-group col-md-6">
                                 <label for="full_description">PDF file:</label>
                                 <input type="file" name="pdf">
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">isbn:</label>
                                <input type="text" name="isbn" id="isbn" placeholder="Write product isbn" class="form-control <?php $__errorArgs = ['isbn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->isbn ?? old('isbn')); ?>" >
                                <?php $__errorArgs = ['isbn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">edition:</label>
                                <input type="text" name="edition" id="edition" placeholder="Write product edition" class="form-control <?php $__errorArgs = ['edition'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->edition ?? old('edition')); ?>" >
                                <?php $__errorArgs = ['edition'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">pages:</label>
                                <input type="text" name="pages" id="pages" placeholder="Write product edition" class="form-control <?php $__errorArgs = ['pages'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->pages ?? old('pages')); ?>" >
                                <?php $__errorArgs = ['pages'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">country:</label>
                                <input type="text" name="country" id="country" placeholder="Write product country" class="form-control <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->country ?? old('country')); ?>" >
                                <?php $__errorArgs = ['country'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group col-md-6">
                                <label for="title">language:</label>
                                <input type="text" name="language" id="language" placeholder="Write product language" class="form-control <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" value="<?php echo e($product->language ?? old('language')); ?>" >
                                <?php $__errorArgs = ['language'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="invalid-feedback"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group col-md-12">
                        <?php if(isset($product)): ?>
                            <div><a target="_blank" href="<?php echo e(asset('uploads/product/video/'.$product->video)); ?>">Click View Video</a>
                            <br>
                            <a target="_blank" href="<?php echo e(asset('uploads/product/video/'.$product->video_thumb)); ?>">Click View Video Thumbnail</a></div>
                        <?php endif; ?>
                            <label for="video">Product Video:</label>
                            <input type="file" name="video" class="form-control <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                            <label for="video">OR Youtbe Video:</label>
                            <input <?php echo e($product->yvideo ?? old('yvideo')); ?> type="text" name="yvideo" class="form-control <?php $__errorArgs = ['yvideo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                            <label for="video_thumb">Product Video Thumbnail:</label>
                            <input type="file" name="video_thumb" class="form-control <?php $__errorArgs = ['video_thumb'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" >
                            <?php $__errorArgs = ['video'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-md-6">
                            <label for="image">Product Thumbnail Image <span class="text-danger">(*)</span>: <a target="_blank" href="#">How to Optimize Image</a></label>
                            <input type="file" name="image" id="image" accept="image/*" class="form-control dropify <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" data-default-file="<?php if(isset($product)): ?> /uploads/product/<?php echo e($product->image); ?><?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                            <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        
                        <div class="form-group col-md-6">
                            <label>Product Gallery Image <span class="text-danger">(*)</span>: <a target="_blank" href="#">How to Optimize Image</a></label>
                            <div class="input-group" id="increment">
                                <input type="file" class="form-control" accept="image/*" id="images" name="images[]"  <?php if(isset($product)): ?> <?php else: ?> required <?php endif; ?>  >
                                <select name="imagesc[]" id="imagesc">
                                    <option value="">Select Color</option>
                                    <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option  style="color:white;background: <?php echo e($color->code); ?>" value="<?php echo e($color->slug); ?>" ><?php echo e($color->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <div class="input-group-append" id="add" style="cursor:context-menu">
                                    <span class="input-group-text">Add More</span>
                                </div>
                            </div>
                            
                            <?php $__errorArgs = ['images'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <div class="invalid-feedback d-block"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

                            <style type="text/css">
                                .d {
                                    display: flex;
                                    align-items: center;
                                    padding: 10px;
                                    margin: 10px 0px;
                                    border-radius: 5px;
                                }
                            </style>

                            <?php if(isset($product)): ?>
                                <?php $__currentLoopData = $product->images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $image): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="d" <?php $__currentLoopData = $colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php if($color->slug==$image->color_attri): ?> style="background: <?php echo e($color->code); ?>" <?php endif; ?> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>>
                                        <img src="<?php echo e(asset('uploads/product/'.$image->name)); ?>" style="width: 100px;height: 70px;object-fit: cover;">
                                        <div style="flex: 1;text-align: right;">
                                            <a  class="btn btn-danger" href="<?php echo e(route('admin.idelte',$image->id)); ?>">Delete</a>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group col-sm-2">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" name="status" id="status" <?php if(isset($product)): ?> <?php echo e($product->status ? 'checked':''); ?> <?php else: ?> checked <?php endif; ?>>
                                <label class="custom-control-label" for="status">Status</label>
                            </div>
                            <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-sm-2">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" name="book" id="book" <?php if(isset($product)): ?> <?php echo e($product->book ? 'checked':''); ?> <?php else: ?>  <?php endif; ?>>
                                <label class="custom-control-label" for="book">book</label>
                            </div>
                            <?php $__errorArgs = ['book'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-sm-2">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" name="sheba" id="sheba" <?php if(isset($product)): ?> <?php echo e($product->sheba ? 'checked':''); ?> <?php else: ?>  <?php endif; ?>>
                                <label class="custom-control-label" for="sheba">sheba</label>
                            </div>
                            <?php $__errorArgs = ['sheba'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                        <div class="form-group col-sm-2">
                            <div class="custom-control custom-switch">
                                <input type="checkbox" class="custom-control-input" name="download_able" id="download_able" <?php if(isset($product)): ?><?php echo e($product->download_able ? 'checked':''); ?> <?php endif; ?>>
                                <label class="custom-control-label" for="download_able">Download able</label>
                            </div>
                            <?php $__errorArgs = ['download_able'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <?php if(isset($product)): ?>
                        <?php if($product->downloads->count() < 1): ?>
                        <div class="modal fade" id="modal-default">
                            <div class="modal-dialog modal-xl">
                                <div class="modal-content">
                                    <div class="modal-header">
                                        <h4 class="modal-title">Add Product Downloadable file</h4>
                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                            <span aria-hidden="true">&times;</span>
                                        </button>
                                    </div>
                                    <div class="modal-body">
                                        <div class="form-horizontal">
                                            <div class="card-body">
                                                <div class="form-group row">
                                                    <label for="inputEmail3" class="col-sm-2 col-form-label">Downloadable Files</label>
                                                    <div class="col-sm-10">
                                                        <div class="card border">
                                                            <div class="card-header">
                                                                <div class="row">
                                                                    <div class="col-md-4">
                                                                        <strong>Name:</strong>
                                                                    </div>
                                                                    <div class="col-md-4"><strong>File URL:</strong></div>
                                                                </div>
                                                            </div>
                                                            <div class="card-body px-1 py-2">
                                                                <div class="row">
                                                                    <div class="col-12" id="increment-file">
                                                                        
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="card-footer">
                                                                <span id="add-file" class="btn btn-success">Add File</span>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="download_limit" class="col-sm-2 col-form-label">Download Limit</label>
                                                    <div class="col-sm-4">
                                                        <input type="number" class="form-control" id="download_limit" name="download_limit" value="<?php echo e($product->download_limit ?? old('download_limit')); ?>">
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <span>Leave blank for unlimited re-downloads</span>
                                                    </div>
                                                </div>
                                                <div class="form-group row">
                                                    <label for="download_expire" class="col-sm-2 col-form-label">Download Expire</label>
                                                    <div class="col-sm-4">
                                                        <input type="date" class="form-control" id="download_expire" name="download_expire" value="<?php echo e($product->download_expire ?? old('download_expire')); ?>">
                                                    </div>
                                                    <div class="col-sm-6">
                                                        <span>Enter the number of days before a downlink link expires, or leave blank</span>
                                                    </div>
                                                </div>
                                            </div>
                                            <!-- /.card-body -->
                                        </div>
                                    </div>
                                    <div class="modal-footer justify-content-between">
                                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                        
                                    </div>
                                </div>
                                <!-- /.modal-content -->
                            </div>
                            <!-- /.modal-dialog -->
                        </div>
                        <?php endif; ?>
                    <?php else: ?>
                    <div class="modal fade" id="modal-default">
                        <div class="modal-dialog modal-xl">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h4 class="modal-title">Add Product Downloadable file</h4>
                                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                        <span aria-hidden="true">&times;</span>
                                    </button>
                                </div>
                                <div class="modal-body">
                                    <div class="form-horizontal">
                                        <div class="card-body">
                                            <div class="form-group row">
                                                <label for="inputEmail3" class="col-sm-2 col-form-label">Downloadable Files</label>
                                                <div class="col-sm-10">
                                                    <div class="card border">
                                                        <div class="card-header">
                                                            <div class="row">
                                                                <div class="col-md-4">
                                                                    <strong>Name:</strong>
                                                                </div>
                                                                <div class="col-md-4"><strong>File URL:</strong></div>
                                                            </div>
                                                        </div>
                                                        <div class="card-body px-1 py-2">
                                                            <div class="row">
                                                                <div class="col-12" id="increment-file">
                                                                    
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="card-footer">
                                                            <span id="add-file" class="btn btn-success">Add File</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="download_limit" class="col-sm-2 col-form-label">Download Limit</label>
                                                <div class="col-sm-4">
                                                    <input type="number" class="form-control" id="download_limit" name="download_limit" value="<?php echo e($product->download_limit ?? old('download_limit')); ?>">
                                                </div>
                                                <div class="col-sm-6">
                                                    <span>Leave blank for unlimited re-downloads</span>
                                                </div>
                                            </div>
                                            <div class="form-group row">
                                                <label for="download_expire" class="col-sm-2 col-form-label">Download Expire</label>
                                                <div class="col-sm-4">
                                                    <input type="date" class="form-control" id="download_expire" name="download_expire" value="<?php echo e($product->download_expire ?? old('download_expire')); ?>">
                                                </div>
                                                <div class="col-sm-6">
                                                    <span>Enter the number of days before a downlink link expires, or leave blank</span>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                </div>
                                <div class="modal-footer justify-content-between">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                                    
                                </div>
                            </div>
                            <!-- /.modal-content -->
                        </div>
                        <!-- /.modal-dialog -->
                    </div>
                    <?php endif; ?>
                    
                    
                </div>
                <div class="card-footer">
                    <button type="submit" class="mt-1 btn btn-primary">
                        <?php if(isset($product)): ?>
                            <i class="fas fa-arrow-circle-up"></i>
                            Update
                        <?php else: ?>
                            <i class="fas fa-plus-circle"></i>
                            Submit
                        <?php endif; ?>
                    </button>
                    
                </div>
            </form>
            <div class="col-sm-4">
                <?php echo $__env->make('components.product-sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
        </div>
    </div>
    <!-- /.card -->
    


    
    <?php if(isset($product->downloads) && $product->downloads->count() > 0): ?>
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">Update Product Download File</h3>
        </div>
        <form action="<?php echo e(routeHelper('update/product/download')); ?>"  class="form-horizontal" method="POST" enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
            <div class="card-body">
                <div class="form-group row">
                    <label for="inputEmail3" class="col-sm-2 col-form-label">Downloadable Files</label>
                    <div class="col-sm-10">
                        <div class="card border">
                            <div class="card-header">
                                <div class="row">
                                    <div class="col-md-4">
                                        <strong>Name:</strong>
                                    </div>
                                    <div class="col-md-4"><strong>File URL:</strong></div>
                                </div>
                            </div>
                            <div class="card-body px-1 py-2">
                                <div class="row">
                                    <div class="col-12" id="increment-file">
                                        <?php if(isset($product->downloads)): ?>
                                            <?php $__currentLoopData = $product->downloads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $download): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <div class="row mt-2">
                                                    <div class="col-md-4">
                                                        <input type="text" name="file_name[]" class="form-control" placeholder="Enter file name" value="<?php echo e($download->name); ?>">
                                                    </div>
                                                    <div class="col-md-4">
                                                        <input type="text" name="file_url[]" class="form-control" placeholder="Enter file url" value="<?php echo e($download->url); ?>">
                                                        
                                                    </div>
                                                    <div class="col-md-2">
                                                        <input type="file" name="files[]" class="custom-file">
                                                    </div>
                                                    <div class="col-md-2">
                                                        <input type="hidden" name="ids[]" value="<?php echo e($download->id); ?>">
                                                        <a href="#" id="remove-file" data-id="<?php echo e($download->id); ?>" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i></a>
                                                    </div>
                                                </div>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <div class="card-footer">
                                <span id="add-file" class="btn btn-success">Add File</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="download_limit" class="col-sm-2 col-form-label">Download Limit</label>
                    <div class="col-sm-4">
                        <input type="number" class="form-control" id="download_limit" name="download_limit" value="<?php echo e($product->download_limit ?? old('download_limit')); ?>">
                    </div>
                    <div class="col-sm-6">
                        <span>Leave blank for unlimited re-downloads</span>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="download_expire" class="col-sm-2 col-form-label">Download Expire</label>
                    <div class="col-sm-4">
                        <input type="date" class="form-control" id="download_expire" name="download_expire" value="<?php echo e($product->download_expire ?? old('download_expire')); ?>">
                    </div>
                    <div class="col-sm-6">
                        <span>Enter the number of days before a downlink link expires, or leave blank</span>
                    </div>
                </div>
            </div>
            <!-- /.card-body -->
            <div class="card-footer">
                <button type="submit" class="btn btn-primary">Update</button>
            </div>
        </form>
    </div> 
    <?php endif; ?>
    

</section>
<!-- /.content -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <!-- Select2 -->
    <script src="/assets/plugins/select2/js/select2.full.min.js"></script>
    <script src="<?php echo e(asset('/assets/plugins/dropify/dropify.min.js')); ?>"></script>
    <script src="/assets/plugins/summernote/summernote-bs4.min.js"></script>
    <script src="/assets/dist/extra.js"></script>
    
    <script type="text/javascript" src="/assets/plugins/file-uploader/image-uploader.min.js"></script>
    <?php if(isset($product)): ?>
        <?php if($product->downloads->count() < 1): ?>
        <script>
            $(document).on('click', '#download_able', function(e) {
                
                if (this.checked) {
                    $('#modal-default').modal('show')
                }
                else {
                    $('#modal-default').modal('hide')
                }
            })
        </script>
        <?php endif; ?>
    <?php else: ?>
    <script>
        $(document).on('click', '#download_able', function(e) {
            
            if (this.checked) {
                $('#modal-default').modal('show')
            }
            else {
                $('#modal-default').modal('hide')
            }
        })
    </script>
    <?php endif; ?>
    
    <script>
        $(document).ready(function () {
            $('.select2').select2();
            $('.dropify').dropify();
            $('#full_description').summernote();
            // $('.input-images-1').imageUploader();

            $('#short_description').summernote();
            $('#spec').summernote();
            
            // increment
            $(document).on('click', '#add', function (e) { 
                
                let htmlData = '<div class="input-group mt-2">';
                htmlData += '<input type="file" class="form-control" accept="image/*" name="images[]" required>';
                htmlData += '<select name="imagesc[]">';
                htmlData += $('#imagesc').html();
                htmlData += '</select>';
                htmlData += '<div class="input-group-append" id="remove" style="cursor:context-menu">';
                htmlData += '<span class="input-group-text">Remove</span>';
                htmlData += '</div>';
                htmlData += '</div>';
                $('#increment').append(htmlData);
            });
            // increment
            $(document).on('change', '#select_color', function (e) { 
               let colors = $(this).val();
                var color = colors.split(',');

                let htmlData = '<div class="input-group mt-2">';
                htmlData += ' <input class="form-control" type="hidden" name="colors[]"  readonly value="'+color[1]+'">';
                htmlData += ' <input class="form-control" type="text"    readonly value="'+color[0]+'">';
                htmlData += ' <input class="form-control" type="number" placeholder="extra price" name="color_prices[]" value="">';
                htmlData += ' <input class="form-control" type="number" placeholder="extra quantity" name="color_quantits[]" value="">';

                htmlData += '<div class="input-group-append" id="remove" style="cursor:context-menu">';
                htmlData += '<span class="input-group-text">Remove</span>';
                htmlData += '</div>';
                htmlData += '</div>';
                $('#increment_color').append(htmlData);
            });
            // remove
            $(document).on('click', '#remove', function(e) {
                $(this).parent().remove();
            });

            // increment file
            $(document).on('click', '#add-file', function (e) {
                let htmlData = '<div class="row mt-2">';
                htmlData += '<div class="col-md-4"><input type="text" name="file_name[]" id="" class="form-control" placeholder="Enter file name"></div>';
                htmlData += '<div class="col-md-4"><input type="text" name="file_url[]" id="" class="form-control" placeholder="Enter file url"></div>';
                htmlData += '<div class="col-md-2"><input type="file" name="files[]" id="" class="custom-file"></div>';
                htmlData += '<div class="col-md-2">';
                htmlData += '<input type="hidden" name="ids[]" value="0">';
                htmlData += '<button type="button" data-id="0" id="remove-file" class="btn btn-danger btn-sm"><i class="fa fa-trash-alt"></i></button></div>';
                htmlData += '</div>';

                $('#increment-file').append(htmlData);
            });

            // remove file
            $(document).on('click', '#remove-file', function(e) {
                e.preventDefault();
                let btn = $(this);
                let id = $(this).data('id');

                if (id == 0) {
                    $(this).parent().parent().remove();
                } 
                else {
                    $.ajax({
                        type: 'GET',
                        url: '/admin/delete/product/download/'+id,
                        dataType: "JSON",
                        beforeSend: function() {
                            $(btn).addClass('disabled');
                        },
                        success: function (response) {
                            $(btn).parent().parent().remove();
                        },
                        complete: function() {
                            $(btn).removeClass('disabled');
                        }
                    });
                }
                
            });

          

            $(document).on('change', '#category', function() {
                
                var options = document.getElementById('category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/sub-categories',
                    data: {
                        'ids': values,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        
                        let data = '<option value="">Select Sub Category</option>';
                        $.each(response, function (key, val) { 
                            data += '<option value="'+val.id+'">'+val.name+'</option>';
                            
                        });
                        $('#sub_category').html(data).attr('multiple', true).select2();
                    }
                });
            });
        
             $(document).on('change', '#sub_category', function() {
                
                var options = document.getElementById('sub_category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/mini-categories',
                    data: {
                        'ids': values,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        
                        let data = '<option value="">Select Mini Category</option>';
                        $.each(response, function (key, val) { 
                            data += '<option value="'+val.id+'">'+val.name+'</option>';
                            
                        });
                        $('#mini_category').html(data).attr('multiple', true).select2();
                    }
                });
            });
             $(document).on('change', '#mini_category', function() {
                
                var options = document.getElementById('mini_category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/extra-categories',
                    data: {
                        'ids': values,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        
                        let data = '<option value="">Select Mini Category</option>';
                        $.each(response, function (key, val) { 
                            data += '<option value="'+val.id+'">'+val.name+'</option>';
                            
                        });
                        $('#extra_category').html(data).attr('multiple', true).select2();
                    }
                });
            });
        });
    </script>
    <?php if(isset($product)): ?>
        <script>
            function productImages() {
                
                let id = '<?php echo $product->id; ?>';
                console.log(id);
                $.ajax({
                    type: 'GET',
                    url: '/admin/get/product/image/'+id,
                    dataType: 'JSON',
                    success: function (response) {
                        
                        let preloaded = [];
                        $.each(response, function (key, val) { 
                            preloaded.push({
                                id: val.id,
                                src: '/uploads/product/'+val.name
                            });
                        });

                        $('.input-images-1').imageUploader({
                            preloaded: preloaded,
                            imagesInputName: 'photos',
                            preloadedInputName: 'old'
                        });
                    }
                });
            }
            productImages();
            function attributes(){
                var options = document.getElementById('category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                var product_id = $('#id').val();
                
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/attributes',
                    data: {
                        'ids': values,
                        'product_id': product_id,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        $('#sho_attributes').html(response);
                    }
                });
            }
            attributes();
            $(document).on('change', '#category', function() {
                
                var options = document.getElementById('category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                var product_id = $('#id').val();
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/attributes',
                    data: {
                        'ids': values,
                        'product_id': product_id,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        $('#sho_attributes').html(response);
                    }
                });
            });
        </script>
        <?php else: ?>
        <script>
                $(document).on('change', '#category', function() {
                
                var options = document.getElementById('category').selectedOptions;
                var values = Array.from(options).map(({ value }) => value);
                
                $.ajax({
                    type: 'POST',
                    url: '/admin/get/attributes',
                    data: {
                        'ids': values,
                        '_token': $('meta[name="csrf-token"]').attr('content'),
                    },
                    dataType: "JSON",
                    success: function (response) {
                        $('#sho_attributes').html(response);
                    }
                });
            });
        </script>
    <?php endif; ?>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-colorpicker/2.5.3/js/bootstrap-colorpicker.min.js"></script>
<script>
    $('#ncolor').colorpicker();


    // Dicount required while change discount type
    $(document).on('change', '#dis_type', function(e) {
        // Check if the selected value is not equal to 0
        if ($(this).val() != "0") {
            // Make discount_price input required
            $('#discount_price').prop('required', true);
        } else {
            // Make discount_price input not required
            $('#discount_price').prop('required', false);
        }
    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.admin.e-commerce.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/elitede1/ecommerce2.elitedesign.com.bd/resources/views/admin/e-commerce/product/form.blade.php ENDPATH**/ ?>